// ------------------------------------------------------------
// Handler
//
// Interface for handlers
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class Handler
{
public:
  enum State {
    stop,
    run
  };

  // Construct with or without state
  Handler(State state = run) :
    _state(state)
  {}

  // Destruct
  virtual ~Handler()
  {}

  // Interface
  virtual void handleRequest() = 0;


  // In the default case the current thread is
  // used to handleRequest()
  virtual void handle()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("HANDLER", this, "Handle");
#endif

    handleRequest();
  }


  // States of this machine
  void state(State arg) {
    _state = arg;
  }
  State state() {
    return _state;
  }

private:
  State _state;
};


