// ------------------------------------------------------------
// Initialize Servers
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


class CInitServer :
  public Command
{
public:
  CInitServer(int id, int port) :
    _id(id),
    _port(port)
  {}
  
  virtual void Do(CommandHandler& handler)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("INITSERVERS", this, "CInitServer Do");
#endif

    Channel* c = ((PqueueChannel*)(handler.queue()))->channel();
    ProcMap::instance()->depickle(*c);
    CommunicationEngine* engine = CommunicationEngine::instance();
    engine->me(_id);    
    engine->connect(_port);
  }

  virtual size_t size()
  {
    return sizeof(*this);
  }

private:
  int _id;
  int _port;
};

class CInitDone :
  public Command
{
public:
  virtual void Do(CommandHandler& handler)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("INITSERVERS", this, "CInitDone Do");
#endif
    
    handler.queue()->enque(this);
  }
  
  virtual size_t size()
  {
    return sizeof(*this);
  }
};


//
// Initialize servers
//
void
initServers(ProcMap& map, int port)
{
#if DEBUG_EE
  DEBUGOBJ dummy("INITSERVERS", NULL, "Initializing servers");
#endif

  int _last = map.num() - 1;
  // Go backwards!
  for (int i = _last; i > 0; i--) {
    Socket socket(map.proc(i), port);

    CInitServer sm(i, port); // Set remote id
    CInitDone mark;

    socket << sm;
    map.pickle(socket); // send proc map
    socket << mark;
    sautoptr<Command> reply(socket);
  }
};
