// ------------------------------------------------------------
// Manager for join commands
//
// Needed to avoid join deadlock
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class JoinManager :
  public Singleton
{
public:
  void add(Command* command) {
    _command->enque(command);
  }
  
protected:
  JoinManager() 
  {
    _command = new PqueueBody<Command*>;
    _handler = new JoinHandler(_command);
    _handler->handle();
  }

  ~JoinManager()
  {
    delete _command; _command = NULL;
  }
  
private:
  Pqueue<Command*>* _command;
  JoinHandler* _handler;
  
  
  // Singleton stuff
public:
  // singleton instance method
  static JoinManager* instance()
  {
    if (_instance == 0) {
      // Make sure no race condition are around
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new JoinManager;
        _singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }

private:
  static JoinManager* _instance;
  static Mutex _me;
};

// Initialization
JoinManager* JoinManager::_instance = 0;
Mutex JoinManager::_me;
