// ------------------------------------------------------------
// Local channel
// Channel to local processor
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class LocalChannel :
  public Channel
{
public:
  virtual void send(const void* data, size_t size) 
  {
    char* temp = new char[size];
    memcpy(temp, data, size);
    _queue.enque((char*)size);
    _queue.enque(temp);
  }

  virtual void receive(void* data, size_t size) 
  {
    size_t _size = (size_t) _queue.deque();
    char* temp = _queue.deque();
    memcpy(data, temp, min(size, _size));
    delete [] temp; temp = NULL;
  }

protected:
  PqueueBody<char*> _queue;
};


