// ------------------------------------------------------------
// mtvector
//
// Thread-safe STL vertor wrapper
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

// One global mutex for interaction with the whole STL
Mutex _STL;

//
// MT-Safe STL Vector (subset)
//

template<class T>
class mtvector
{
public:
  mtvector() {
    Synchronize _with(_STL);
    _vector = new vector<T>;
  }

  ~mtvector() {
    Synchronize _with(_STL);
    delete _vector; _vector = NULL;
  }

  void pop_back() {
    Synchronize _with(_STL);
    _vector->pop_back();
  }

  void push_back(const T& arg) {
    Synchronize _with(_STL);
    _vector->push_back(arg);
  }

  T& back() {
    Synchronize _with(_STL);
    return _vector->back();
  }

  int empty() {
    Synchronize _with(_STL);    
    return _vector->empty();
  }

  T& operator[](int n) {
    Synchronize _with(_STL);    
    return _vector->operator[](n);
  }

  int size() {
    Synchronize _with(_STL);    
    return _vector->size();
  }
    
private:
  vector<T>* _vector;
};


