// ------------------------------------------------------------
// MDS_mutex
// Class Implementation
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Constructor
//

Mutex::Mutex() // throw (ExInit) 
{
#if PTHREADS
  if (pthread_mutex_init(&_t, NULL)) {
    throw ExInit(__FILE__, __LINE__);
  }
#elif UITHREADS
  if (mutex_init(&_t, USYNC_THREAD, 0)) {
    throw ExInit(__FILE__, __LINE__);
  }
#endif
}


//
// Destructor
//

Mutex::~Mutex() // throw (ExDestroy)
{
#if PTHREADS
  if (pthread_mutex_destroy(&_t)) {
    throw ExDestroy(__FILE__, __LINE__);
  }
#elif UITHREADS
  if (mutex_destroy(&_t)) {
    throw ExDestroy(__FILE__, __LINE__);
  }
#endif
}


//
// Lock
//

void
Mutex::lock() // throw (ExLock, ExDeadLock)
{
#if DEBUG_EE_MUTEX
  DEBUGOBJ dummy("MUTEX", this, "Lock");
#endif
  
  int ret;
    
#if PTHREADS
  if ((ret = pthread_mutex_lock(&_t)) != 0) {
    switch (ret) { 
    case EDEADLK:
      throw ExDeadLock(__FILE__, __LINE__, ret);
      break;
    default:
      throw ExLock(__FILE__, __LINE__, ret);
    }
  }
#elif UITHREADS
  if ((ret = mutex_lock(&_t)) != 0) {
    switch (ret) {
    default:
      throw ExLock(__FILE__, __LINE__, ret);
    }
  }

#endif   
}


//
// Trylock
//

int
Mutex::trylock() // throw ()
{
#if DEBUG_EE_MUTEX
  DEBUGOBJ dummy("MUTEX", this, "Trylock");
#endif

#if PTHREADS
  return pthread_mutex_trylock(&_t);
#elif UITHREADS
  return mutex_trylock(&_t);
#endif
}


//
// Unlock
//

void
Mutex::unlock() // throw (ExUnlock)
{
#if DEBUG_EE_MUTEX
  DEBUGOBJ dummy("MUTEX", this, "Unlock");
#endif

#if PTHREADS
  if (pthread_mutex_unlock(&_t)) {
    throw ExUnlock(__FILE__, __LINE__);
  }
#elif UITHREADS
  if (mutex_unlock(&_t)) {
    throw ExUnlock(__FILE__, __LINE__);
  }
#endif
}












