// ------------------------------------------------------------
// Mutex
// Class Signature
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class Mutex
{
public:

  //
  // Exceptions
  //
  
  class ExInit :
    public Exception
  {
  public:
    ExInit(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Mutex Init";
    }
  };

  class ExDestroy :
    public Exception
  {
  public:
    ExDestroy(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Mutex Destroy";
    }
  };

  class ExLock :
    public Exception
  {
  public:
    ExLock(char* file, int line, int status) :
      _status(status),
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Mutex Lock:status=" << _status;
    }

    int _status;
  };

  class ExDeadLock :
    public ExLock
  {
  public:
    ExDeadLock(char* file, int line, int ret) :
      ExLock(file, line, ret)
    {}
    void print(ostream& os) const {
      os << "Mutex DeadLock";
    }
  };

  class ExUnlock :
    public Exception
  {
  public:
    ExUnlock(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Mutex Unlock";
    }
  };

  //
  // Methods
  //

  Mutex(); //throw (ExInit)
  ~Mutex(); // throw (ExDestroy)

  void lock(); // throw (ExLock, ExDeadLock)
  int trylock(); // throw ()
  void unlock(); // throw (ExUnlock)


  // Allow condition variables to
  // directly manipulate Mutexes
  friend class Cond;

protected:
#if PTHREADS
  pthread_mutex_t _t;
#elif UITHREADS
  mutex_t _t;
#endif
};


