// ------------------------------------------------------------
// Stream interfaces
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


//
// Pickle for built in types
//

void
pickle(Channel& channel, char& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, unsigned char& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, signed char& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, short int& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, int& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, long& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, float& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, double& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}
void
pickle(Channel& channel, long double& arg) {
  size_t size = sizeof(arg);
  channel.send(&size, sizeof(size_t));
  channel.send(&arg, sizeof(arg));
}

//
// Pickle user provided data-type
//

template <class T>
void
pickle(Channel& channel, T& arg) {
  arg.pickle(channel);
}





