// ------------------------------------------------------------
// Queues
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------



//
// Implementation of Local
// of queues
//
template <class T>
class PqueueBody : public Pqueue<T>
{
public:
  PqueueBody(int head = 1, int tail = 1) :
    _me(),
    _tail(NULL), 
    _head(NULL),
    _cEmpty(TRUE),
    _cFull(FALSE),
    _eoq(head),
    _tailcount(tail),
    _freequeue(NULL)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Construction");
#endif 
  }

  //
  // Clean up
  ~PqueueBody()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Destruction");
#endif 
    while (_freequeue) {
      Holder* temp = _freequeue;
      _freequeue = temp->tail();
      delete temp; temp = NULL;
    }
  }

  //
  // Enque element to queue
  // All synchronization is handled here
  virtual void enque(const T& arg)
  {
    // Provide all synchonization 
    Synchronize with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Enque");
#endif 

#if 0
    Wait _while(_cFull, _me, _cEmpty);
#endif

    Holder* temp;

    if (_freequeue == NULL) {
      temp = new Holder(arg);
    } else {
      temp = _freequeue;
      _freequeue = temp->tail();
      *temp = arg;
    }

    _enque(temp);
    if (_cEmpty.value() == TRUE) {
      _cEmpty.value(FALSE);
    }
  }

  //
  //
  //


  virtual Holder* gimmeHolder()
  {
    // Provide all synchonization 
    _me.lock();
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Gimme holder");
#endif 

#if 0
    Wait _while(_cFull, _me, _cEmpty);
#endif

    Holder* temp;

    if (_freequeue == NULL) {
      temp = new Holder;
    } else {
      temp = _freequeue;
      _freequeue = temp->tail();
    }
    
    return temp;
  }


  
  virtual void enqueHolder(Holder* temp)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Enque Holder");
#endif 

    _enque(temp);
    
    if (_cEmpty.value() == TRUE) {
      _cEmpty.value(FALSE);
    }
    _me.unlock();
  }

  

  //
  // Deque
  virtual T deque(int /* who */ = 0, bool wait  = TRUE) // throw (ExDead)
  {
    // Provide all synchonization 
    Synchronize _with(_me);

#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "Deque");
#endif 
    
    // for each left eoq maker
    while (_eoq) {
      if (!wait) {
	if (_cEmpty.value() == TRUE) throw ExEmpty(__FILE__, __LINE__);
      }

      Wait _while(_cEmpty, _me
#if 0
      , _cFull
#endif
      );


      // if waiting on eoq break;
      if (_eoq == 0) {
#if 0
        _cFull.value(FALSE);
#endif
        break;
      }
      
      // deque
      Holder* temp = _deque();

      // if it a marker
      if (temp->type() == Holder::Eoq) {
        // decrement index
        _eoq--;
        delete temp; temp = NULL;

        continue;
      } else {
	//        delete temp; temp = NULL;
	temp->tail(_freequeue);
	_freequeue = temp;

        // Memory is still valid because in critical section
	return temp->element();
      }
    }

    // if queue is dead
    _cEmpty.value(FALSE);
    throw ExDead(__FILE__, __LINE__);
  }


  //
  // Terminate queue
  virtual void eoq()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("QUEUE", this, "eoq");
#endif 

    // Provide all synchonization 
    Synchronize with(_me);
    Wait _while(_cFull, _me, _cEmpty);
    Holder* temp = new Holder(Holder::Eoq);
    _enque(temp);
  }

  virtual int tail() {
    Synchronize _with(_me);
    return _tailcount;
  }

  virtual void tail(int tail) {
    Synchronize _with(_me);
    _tailcount = tail;
  }

  virtual int head() {
    Synchronize _with(_me);
    return _eoq;
  }

  virtual void head(int head) {
    Synchronize _with(_me);
    _eoq = head;
  }
  
protected:
  //
  // Add to LL
  void _enque(Holder* arg)
  {
    // Add argument to list
    if (_tail != NULL) {
      _tail->tail(arg);
    } 
    if (_head == NULL) {
      _head = arg;
    }
    _tail = arg;
  }

  //
  // Remove from LL
  Holder* _deque()
  {
#if DEBUG
    assert(_head != NULL);
#endif

    Holder* arg = _head;

    // Update list
    _head = _head->tail();

    if (_head == NULL) {
      _tail = NULL;
      _cEmpty.value(TRUE, FALSE);
    }
    return arg;
  }

protected:
  Cond  _cEmpty;
  Cond  _cFull;
  Mutex _me;

private:
  Holder* _tail;
  Holder* _head;
  int _eoq;
  int _tailcount;

  Holder* _freequeue;
};



