// ------------------------------------------------------------
// Queues sigantures
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Class to be able to pass a templateless
// pointer to queues around
//

class PqueueBase
{
public:
  class ExDead :
    public Exception
  {
  public:
    ExDead(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Queue dead";
    }
  };

  class ExEmpty :
    public Exception
  {
  public:
    ExEmpty(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Queue Empty";
    }
  };

  virtual int head() {return 1;}
  virtual void head(int /*head*/) {}
  virtual int tail() {return 1;}
  virtual void tail(int /*tail*/) {}

private:
  int _head;
  int _tail;
};


//
// Queue interface
//

template <class T>
class Pqueue :
  public PqueueBase
{
public:
  class Holder
  {
  public:  
    enum Type {
      Data,
      Eoq
    };

    Holder(Type type = Data) :
      _type(type),
      _tail(NULL)
    {}

    Holder(const T& arg, Type type = Data) :
      _element(arg),
      _type(type),
      _tail(NULL)
    {}

    void operator=(const T& arg) {
      _element = arg;
      _type = Data;
      _tail = NULL;
    }

    // Functionality for Type
    void type(Type arg) {
      _type = arg;
    }
    Type type()  {
      return _type;
    }
    T& element()   {
      return _element;
    }

    // Functionality for List
    void tail(Holder* arg) {
      _tail = arg;
    }
    Holder* tail() {
      return _tail;
    }
  
  private:
    T _element;
    Type _type;
    Holder* _tail;

    // Ensure no copies of this class
    Holder(Holder& arg) {}
  };


public:
  virtual void enque(const T& arg) = 0;
  virtual T deque(int who = 0, bool wait = TRUE) /* throw(ExDead) */ = 0;
  virtual void eoq() = 0;

  virtual Holder* gimmeHolder() {return NULL;}
  virtual void enqueHolder(Holder*) {}
};



