// ------------------------------------------------------------
// Queues sigantures
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class PqueueChannel :
  public Pqueue<Command*>
{
public:
  PqueueChannel(Channel* channel) :
    _channel(channel)
  {}

  virtual void enque(Command* const & arg)
  {
    Synchronize _with(*(_channel->send_mutex()));
    arg->pickle(*_channel);
  }

  virtual Command* deque(int /* who */, int /* wait */ = TRUE) // throw(ExDead) 
  {
    sautoptr<Command> command(*_channel, FALSE);
    return command.operator->();
  }

  virtual void eoq() 
  {
  }

  Channel* channel() {
    return _channel;
  }

protected:
  Channel* _channel;
};

