// ------------------------------------------------------------
// Handles for Pqueues
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T>
class PqueueHandle :
  public Pqueue<T>
{
public:
  PqueueHandle() :
    _body(NULL)
  {}

  PqueueLocator locator() {
    return _locator;
  }
  void locator(PqueueLocator& locator) {
    _locator = locator;
  }

  void initialize(int who = 0)
  {
    _who = who;

#if DISTMEM
    if (_locator._where == CommunicationEngine::instance()->me()) {
#endif
#if DEBUG_EE
      DEBUGOBJ dummy("PQUEUEHANDLE", this, "Setting local proxy");
#endif
      _body = (Pqueue<T>*) _locator._queue;

#if DISTMEM
    } else {
# if DEBUG_EE
      DEBUGOBJ dummy("PQUEUEHANDLE", this, "Setting remote proxy");
# endif
      _body = new PqueueRemote<T>(_locator);
    }
#endif
  };

  virtual int head() {
#if DEBUG
    assert(_body != NULL);
#endif

    return _body->head();
  }    

  virtual void head(int head) {
#if DEBUG
    assert(_body != NULL);
#endif

    _body->head(head);
  }    


  virtual void enque(const T& arg) {
#if DEBUG
    assert(_body != NULL);
#endif

    _body->enque(arg);
  }

  virtual T deque(int /* who */, bool wait = TRUE) /* throw(ExDead) */ {
#if DEBUG
    assert(_body != NULL);
#endif

    return _body->deque(_who, wait);
  }
  
  virtual void eoq() {
#if DEBUG
    assert(_body != NULL);
#endif

    _body->eoq();
  }
  
protected:
  Pqueue<T>* _body;
  PqueueLocator _locator;
  int _who;
};


//
// Type based operators
//

template <class T>
class I_PqueueHandle :
  public PqueueHandle<T>
{
public:
  I_PqueueHandle() :
    _dead(FALSE)
  {}

  //
  // Allow checking for eoq
  bool eos() {
    return _dead;
  }

  //
  // Allow cast to bool for eos checking
  operator bool() const {
    return !_dead;
  }

  I_PqueueHandle<T>& operator >> (T& arg) /* throw (ExDead) */ {
    if (_dead == FALSE) {
      try {
	arg = deque(_who);
      } catch (PqueueBase::ExDead& e) {
	_dead = TRUE;
	CATDEBUG("EXCEPTIONSYNC", cerr << e);
      }
    } else {
      throw PqueueBase::ExDead(__FILE__, __LINE__);
    } 

    return *this;
  }


  bool attempt(T& arg) {
    if (_dead == FALSE) {
      try {
	arg = deque(_who, FALSE);
      } catch (PqueueBase::ExDead& e) {
	_dead = TRUE;
	CATDEBUG("EXCEPTIONSYNC", cerr << e);
	return FALSE;
      } catch (PqueueBase::ExEmpty& e) {
	return FALSE;
      }
    } else {
      throw PqueueBase::ExDead(__FILE__, __LINE__);
    } 

    return TRUE;
  }


protected:
  bool _dead;
};



template <class T>
class O_PqueueHandle :
  public PqueueHandle<T>
{
public:
  O_PqueueHandle<T>& operator << (const T& arg) {
    enque(arg);
    return *this;
  }
};







