// ------------------------------------------------------------
// Class wrapper around creating remote queues.
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Create queue remotely
//
template <class T>
class PqueueInstantiator :
  public PqueueLocator
{
public:
#if SHMEM
  PqueueInstantiator(int phead, int ptail, int broadcast = FALSE) :
    _broadcast(broadcast),
    PqueueLocator(phead, ptail) 
  {
    if (_broadcast) {
      _queue = new PqueueBroadCastBody<T>(head(), tail());
    } else {
      _queue = new PqueueBody<T>(head(), tail());
    }
  }
#elif DISTMEM
  PqueueInstantiator(int phead, int ptail, const proc_t& where, int broadcast = FALSE) :
    _broadcast(broadcast),
    PqueueLocator(phead, ptail)
  {
    // Create queue in the remote machine
    // Create A queue remotely
    CreateRemoteQueue<T> createQueue(head(), tail(), _broadcast);

    Channel* c = ProcMap::instance()->channel(where);
    
    *c << createQueue;

    createQueue.wait();
    _where = where;
    _queue = createQueue.data_queue();
    _dequequeue = createQueue.command_queue();
  }
#endif

protected:
  int _broadcast;
};
