// ------------------------------------------------------------
// Locator for queues
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class PqueueLocator
{
public:
  PqueueLocator(int head = 1, int tail = 1) :
    _queue(NULL),
    _numhead(head),
    _numtail(tail)
#if DISTMEM
    ,_where(0)
#endif
  {}

  //
  // Helpers
  void tail(int tail) {
    _queue->tail(tail);
    _numtail = tail;
  }
  int tail() {
    return _numtail;
  }
  void head(int head) {
    _numhead = head;
    _queue->head(head);
  }
  int head() {
    return _numhead;
  }

  //
  // Data
  PqueueBase* _queue;

#if DISTMEM
  proc_t _where;
  Pqueue<Command*>* _dequequeue;
#endif

private:  
  int _numhead;
  int _numtail;
};

