// ------------------------------------------------------------
// Remote Queues
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T>
class PqueueRemote : public Pqueue<T>
{
public:
  PqueueRemote(PqueueLocator& loc) : 
    _remote((Pqueue<T>*) loc._queue),
    _dequequeue(loc._dequequeue),
    _where(loc._where)
  {}
  
  operator PqueueBase*() {
    return _remote;
  }
  
  virtual void enque(const T& arg)
  {
    Synchronize _with(_enque);
#if DEBUG_EE
    DEBUGOBJ dummy("REMOTEQUEUE", this, "Enque");
#endif

    Enque<T> enque(_remote, arg);
    //    enque.arg(arg);

    Channel* c = ProcMap::instance()->channel(_where);
    *c << enque;
  }

  virtual T deque(int who = 0, int /* wait */ = TRUE) // throw (ExDead)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("REMOTEQUEUE", this, "Deque");
#endif

    Synchronize _with(_deque);
    Deque<T> deque(_remote, _dequequeue, who);
    Channel* c = ProcMap::instance()->channel(_where);
    *c << deque;
    deque.wait();
    return deque.arg();
  }

  virtual void eoq()
  {
    Synchronize _with(_enque);
#if DEBUG_EE
    DEBUGOBJ dummy("REMOTEQUEUE", this, "Eoq");
#endif

    Eoq<T> eoq(_remote);
    Channel* c = ProcMap::instance()->channel(_where);
    *c << eoq;
  }

protected:
  const proc_t _where;
  Pqueue<T>* _remote; // Local queue in remote machine!
  Pqueue<Command*>* _dequequeue;

private:
  Mutex _enque;
  Mutex _deque;
};





