// ------------------------------------------------------------
//
// Singleton to manage processor binding
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


class ProcBinding :
  public Singleton
{
public:
  enum where {
    whereever = -1
  };
  
  proc_t where()
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCBINDING", this, "where");
#endif

    if (_current == 0) {
      _current = _limit;
    }

    return --_current;
  }
  
protected:
  ProcBinding() :
    _limit(ProcMap::instance()->num())
  {
    _current = _limit;
  }

  ~ProcBinding()
  {}
  
private:
  proc_t _current;
  proc_t _limit;
  
  // Singleton stuff
public:
  // singleton instance method
  static ProcBinding* instance()
  {
    if (_instance == 0) {
      // Make sure no race condition are around
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new ProcBinding;
        _singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }

private:
  static ProcBinding* _instance;
  static Mutex _me;
};

// Initialization
ProcBinding* ProcBinding::_instance = 0;
Mutex ProcBinding::_me;
