// ------------------------------------------------------------
// Processor to id mapping object
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Proc Map
//

class ProcMap :
  public Singleton,
  public Streamable
{
public:

  //
  // Exceptions
  //
  
  class ExIndexBound :
    public Exception
  {
  public:
    ExIndexBound(char* file, int line) :
      Exception(file, line)
    {}
    virtual void print(ostream& os) const {
      os << "Index Out of Bounds";
    }
  };

  //
  // Methods
  //
  
  //
  // Number of procesors
  int num() const
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Num Get");
#endif

    return _size;
  }
  
  void channel(int index, Channel* channel)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Channel set");
#endif

    if ((0 <= index) && (index < _size)) {
      _channellist[index] = channel;
    } else {
      throw ExIndexBound(__FILE__, __LINE__);
    }
  };

  Channel* channel(int index)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Channel Get");
#endif

    if ((0 <= index) && (index < _size)) {
      return _channellist[index];
    } else {
      throw ExIndexBound(__FILE__, __LINE__);
    }
  }

  char* proc(int index)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Proc Get");
#endif

    if ((0 <= index) && (index < _size)) {
      return _proclist[index];
    } else {
      throw ExIndexBound(__FILE__, __LINE__);
    }
  }
  
  // Setup
  // No robustness included in this code
  void setup(char* filename)
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Setup");
#endif

    char* temp;
    
    ifstream file(filename);
    if (!file) {

      temp = new char[MAX_PROC_NAME_STRING];
      gethostname(temp, MAX_PROC_NAME_STRING);
      _proclist.push_back(temp);
    } else {
      while (!file.eof()) {
        temp = new char[MAX_PROC_NAME_STRING];
        file.getline(temp, MAX_PROC_NAME_STRING);
        // Don't let black lines count
        if (strlen(temp) != 0) {
          _proclist.push_back(temp);
        }
      }
    }

    _size = _proclist.size();
    _channellist = new Channel*[_size];
  }

  //
  // Size of object
  virtual size_t size() {
    return sizeof(*this);
  }

  //
  // Stream stuff
  virtual void pickle(Channel& channel) 
  {
    Synchronize _with(_me);
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "putToChannel");
#endif

    channel.send(&_size, sizeof(_size));
    for (int i = 0; i < _size; i++) {
      char* temp = _proclist[i];
      int strsize = strlen(temp) + 1;
      channel.send(&strsize, sizeof(strsize));
      channel.send(temp, strsize);
    }
  }
  
  virtual void depickle(Channel& channel)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "depickle");
#endif
    Synchronize _with(_me);
    // Clean up

    // This works on AIX? not on Solaris
    //this->ProcMap::~ProcMap();
    
    channel.receive(&_size, sizeof(_size));
    _channellist = new Channel*[_size];

    for (int i = 0; i < _size; i++) {
      int strsize = 0;
      channel.receive(&strsize, sizeof(strsize));
      char* temp = new char[strsize];
      channel.receive(temp, strsize);
      _proclist.push_back(temp);
    }
  }


protected:
  ProcMap() :
    _size(0)
  {}

  ~ProcMap()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("PROCMAP", this, "Destructor");
#endif

    // reclaim memory in vector
    while (!_proclist.empty()) {
      delete [] _proclist.back();
      _proclist.pop_back();
    }

    // reclaim memory in vector
    for (int i = 0; i < _size; i++) {
      delete _channellist[i]; _channellist[i] = NULL;
    }
    delete _channellist; _channellist = NULL;
  }
  
private:
  mtvector<char*> _proclist;
  Channel** _channellist;
  int _size;

  
public:
  static ProcMap* instance()
  {
    if (_instance == 0) {
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new ProcMap;
        _singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }
  
private:
  static ProcMap* _instance;
  static Mutex _me;
};

// Initialization
ProcMap* ProcMap::_instance = 0;
Mutex ProcMap::_me;

