// ------------------------------------------------------------
// RecursiveSync
//
// Synchronization primitive that behaves as recursive mutex
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

#if PTHREADS

//
// Posix check for recursive mutex locking
// So we can catch exception and have this
// class make sense
//

class RecursiveSync
{
public:
  //
  // Lock mutex on construction
  RecursiveSync(Mutex& mutex) :
    _mutex(&mutex),
    _owner(TRUE)
  {
    _lock();
  }

  //
  // Release it if owner
  ~RecursiveSync()
  {
    if (_owner) {
      _mutex->unlock();
    }
  }
  
protected:
  //
  // Internal lock so code is in one place for
  // all constructors
  void _lock()
  {
    try {
      _mutex->lock();
    } catch (Mutex::ExDeadLock & e) {
      // Allow recursive mutex lock
      _owner = FALSE; // Original Locker will unlock
      CATDEBUG("EXCEPTIONSYNC", cerr << e);
    }
  }

private:
  Mutex* _mutex;
  bool _owner;
};

#endif


