// --------------------------------------------------
// Reducer
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------


template<class T_IN, class T_OUT>
class Reduce :
  public IO_we<T_IN, T_OUT>
{
public:
  Reduce(const Binary_Op<T_OUT, T_IN, T_IN>& op) :
    _count(0),
    _op(&op)
  {}

  ~Reduce()
  {}

  virtual void instantiate(DfeNode& parent, AeHandle& handle)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("INSTANTIATE", this, "Reduce");
#endif

    _count = parent.left()->right()->num();
    We::instantiate(parent, handle);
  }



  virtual void execute() {
    T_OUT total;
    T_IN  a;
    
    
    while (pin >> total) {
      for (int i = 1; i < _count; i++) {
	if (pin >> a) {
	  total = _op->operator()(total, a);
	} else {
	  return;
	}
      }
      pout << total;
    }
  }

  We* clone() {
    return new Reduce<T_IN, T_OUT>(*this);
  }

  virtual size_t size() {
    return sizeof(*this);
  }

private:
  int _count;
  const Binary_Op<T_OUT, T_IN, T_IN>* _op;
};

