// --------------------------------------------------
// Replicator DfeOpnode
//
// mauricio De Simone
// mdeimone@uwaterloo.ca
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// Replication operation container
// Base class
//
class Rep :
  public DfeOpnode
{
public:

  //
  // Exceptions
  //
  
  class ExSetLeft :
    public Exception
  {
  public:
    ExSetLeft(char* file, int line) :
      Exception(file, line)
    {}

    virtual void print(ostream& os) const {
      os << "Set left node of a replication";
    }
  };

  //
  // Members
  //
  
  Rep() :
    _groupcount(0),
    _num(0)
  {}

  //
  // Number in the replication
  virtual int num() {
#if DEBUG_EE
    DEBUGOBJ dummy("REPLICATION", this, "Getting Num");
#endif

    return _num;
  }

  virtual void num(int num) {
    _num = num;
  }

  // 
  // Get Id in group
  virtual int getIdInGroup() {
    return _groupcount++;
  }

  //
  // Instantiate
  virtual void instantiate(DfeNode& /* parent */, AeHandle& handle)
  {
    _groupcount = 0; // initialize group count

#if DISTMEM
    bool _position = FALSE;
      if (_right->where() == ProcBinding::whereever) {
	_position = TRUE;
      } 
#endif


    for (int i = 0; i < _num; i++) {
#if DISTMEM
      if (_position) {
        _right->where(ProcBinding::instance()->where());
      }
#endif

      DfeNode::instantiate(*this, handle);
    }
    
#if DISTMEM
    if (_position = TRUE) {
      _right->where(ProcBinding::whereever);
    }
#endif
  }

  void left(const DfeNode*) {
    // Can't set left side of a replication!!
    throw ExSetLeft(__FILE__, __LINE__);
  }


#if DISTMEM
  //
  // Where
  virtual proc_t where() {
    return _where;
  }
  virtual void where(proc_t where) {
    _where = where;
  }
#endif


protected:
  int _num;

#if DISTMEM
  proc_t _where;
#endif

  int _groupcount;
};

//
// Closed replication
//
class C_Rep :
  public Rep,
  public C_DfeOpnode

{};

//
// Input replication
//
template <class T_IN>
class I_Rep :
  public Rep,
  public I_DfeOpnode<T_IN>
{
public:
  // Set source
  void source(PqueueLocator& loc) {
    right()->source(loc); 
  }
};

//
// Output Replication
//
template <class T_OUT>
class O_Rep :
  public Rep,
  public O_DfeOpnode<T_OUT>
  
{
public:
  // Set sink
  void sink(PqueueLocator& loc) {
    right()->sink(loc);
  }
};

//
// Input/Output Replication
//
template <class T_IN, class T_OUT>
class IO_Rep :
  public Rep,
  public IO_DfeOpnode<T_IN, T_OUT>
{
public:
  // Set sink
  void sink(PqueueLocator& loc) {
    right()->sink(loc); 
  }

  // Set source
  void source(PqueueLocator& loc) {
    right()->source(loc); 
  }
};


// --------------------------------------------------
// Replication Operators
// --------------------------------------------------
//
// Rep Closed
//
C_Rep&
operator*(int num, const C_DfeNode& arg)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "* (C)");
#endif

  C_Rep* node = new C_Rep;
  node->num(num);
  node->right(&arg);

  return *node;
}

//
// Rep Output
//
template <class T>
O_Rep<T>&
operator*(int num, const O_DfeNode<T>& arg)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "* (O)");
#endif

  O_Rep<T>* node = new O_Rep<T>;
  node->num(num);
  node->right(&arg);

  return *node;
}

//
// Rep Input
//
template <class T>
I_Rep<T>&
operator*(int num, const I_DfeNode<T>& arg)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "* (I)");
#endif

  I_Rep<T>* node = new I_Rep<T>;
  node->num(num);
  node->right(&arg);

  return *node;
}

//
// Rep Input/Output
//
template <class T0, class T1>
IO_Rep<T0, T1>&
operator*(int num, const IO_DfeNode<T0, T1>& arg)
{
#if DEBUG_EE
  DEBUGOBJ dummy("OPERATORS", NULL, "* (IO)");
#endif

  IO_Rep<T0, T1>* node = new IO_Rep<T0, T1>;
  node->num(num);
  node->right(&arg);

  return *node;
}

