// ------------------------------------------------------------
// RTS
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


// Deamon thead id
Thread_t deamon_t;


class RTS
{
public:
  //
  // Initialize everything
  //
  RTS(int argc, char* argv[])
  {
    // Get parent information from command line
    // made static to be able to pass to other threads
    static int port = atoi(parseCommandLineArguments(argc, argv, "-port"));
    
    if (strcmp(parseCommandLineArguments(argc, argv, "-role"), "server") == 0) {
      // Steal main's thread to run server deamon
      deamon(&port);
    } else {
      // Retreive process file
      char* procfile = parseCommandLineArguments(argc, argv, "-procfile");
      // Setup process mapping associative array
      ProcMap::instance()->setup(procfile);
      
      // Start servers in all machines
      startUpServers(*ProcMap::instance(), argv[0], port);
      initServers(*ProcMap::instance(), port);
      
      CommunicationEngine::instance()->me(0);
      CommunicationEngine::instance()->connect(port);
      
      // Start a thread to run a local handler
      ThreadEngine::instance()->create_local(deamon_t, deamon, &port);

      CommunicationEngine::instance()->waitUntilInit();
    }
  }

  //
  // Cleanup
  //
  ~RTS()
  {
    CommunicationEngine::instance()->stopServers();
    ThreadEngine::instance()->join(deamon_t);
  }
};





