// ------------------------------------------------------------
// sautoptr
//
// Streamable auto pointer
// Stream content!
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T>
class sautoptr 
{
public:
  // construct from channel
  sautoptr(Channel& channel, bool owner = TRUE) :
    _data(NULL),
    _size(0),
    _owner(owner)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("SAUTOPTR", this, "Creating From Channel");
#endif

    channel.receive(&_size, sizeof(_size));
    _data = (T*) new char[_size];
    channel.receive(_data, _size);
  }


  // If owner destroy
  virtual ~sautoptr() {
    if (_owner == TRUE) {
      delete _data; _data = NULL;
    }
  }

  //
  // Access funtions
  //
  
  T* operator ->() {
    return _data;
  }

  T& operator*() {
    return *_data;
  }

private:
  T* _data;
  size_t _size;
  bool _owner;
};




