// ------------------------------------------------------------
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


class Semaphore
{
public:
  Semaphore() 
  {}

  Semaphore(int init) 
  {
    value(init);
  }
    
  void set() {
    Synchronize _with(_me);
    int _temp = _cond.value();
    _cond.value(++_temp);
  }

  void reset() {
    Synchronize _with(_me);
    int _temp = _cond.value();
    if (_temp > 0) {
      _cond.value(--_temp);
    } else {
      _cond.signal();
    }
  }

  void value(int value) {
    Synchronize _with(_me);
    _cond.value(value);
  }

  Mutex& mutex() {
    return _me;
  }

  Cond& cond() {
    return _cond;
  }


private:
  Mutex _me;
  Cond _cond;
};
