// ------------------------------------------------------------
// Server interface
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Server interface
//
template <class T>
class Server
{
public:
  Server()
  {
    ServerStatus::instance()->set(ThreadEngine::instance()->self());
  }

  // Initiate the Server
  virtual void run() = 0;

  T* newHandler(Channel* channel) {
    return new T(new PqueueChannel(channel));
  }

protected:
  // Access server state
  int _run() {
    return (ServerStatus::instance()->state() == ServerStatus::run);
  }
};
