// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Status of server
// Allow external threads to shutdown server
//

class ServerStatus :
  public Singleton
{
public:
  // Server states
  enum State {
    stop,
    run
  };

  void set(const Thread_t& t)
  {
    Synchronize _with(_me);
    _t = t;
  }
  
  // return the state of the server
  int state()
  {
    Synchronize _with(_me);
    return _state;
  }

  // Set State for server
  void state(State value)
  {
    Synchronize _with(_me);
    _state = value;
    if (_state == stop) {
      ThreadEngine::instance()->kill(_t, SIGUSR1);
    }
  }


protected:
  ServerStatus() :
    _state(run)
  {
    struct sigaction act;
    sigemptyset(&act.sa_mask);
    act.sa_handler = &terminateServer;
    act.sa_flags = 0;
    if (sigaction(SIGUSR1, &act, NULL) < 0) {
      FAIL("SIGNAL INSTALATION");
    }
  }

  virtual ~ServerStatus()
  {}
  

private:
  State _state;
  Thread_t _t;
  
  // Singleton stuff
public:
  // singleton instance method
  static ServerStatus* instance()
  {
    if (_instance == 0) {
      // Make sure no race condition are around
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new ServerStatus;
        _singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }

private:
  static ServerStatus* _instance;
  static Mutex _me;
};

// Initialization
ServerStatus* ServerStatus::_instance = 0;
Mutex ServerStatus::_me;





