// ------------------------------------------------------------
// Shared Objects
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T>
class Shared 
{
public:
  Shared(T* obj) : 
    _obj(obj),
    _owner(TRUE)
  {
    _me = new Mutex;
    _count = new Semaphore;
  }


  Shared(const Shared<T>& other)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Copy Constructor");
#endif

    _owner = FALSE;
    _obj = other._obj;
    _me = other._me;
    _count = other._count;
  }

  ~Shared() {
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Destructor");
#endif

    if (_owner == TRUE) {
      delete _me; _me = NULL;
      delete _count; _me = NULL;
    }
  }


  virtual void readlock() const {
    Synchronize _with(*_me);
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Read Lock");
#endif
    _count->set();
  }
  virtual void readunlock() const {
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Read Unlock");
#endif

    _count->reset();
  }

  virtual void writelock() {
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Write Lock");
#endif

    _me->lock();
    Wait _for(*_count);

  }
  virtual void writeunlock() {
#if DEBUG_EE
    DEBUGOBJ dummy("SHAREDREG", this, "Write Unlock");
#endif

    _me->unlock();
  }


  friend WriteLock<T>;
  friend ReadLock<T>;

protected:
  T* obj() {
    return _obj;
  }
  const T* obj() const {
    return _obj;
  }
  
  
private:
  T*         _obj;
  Mutex*     _me;
  Semaphore* _count;
  bool       _owner;
};





