// ------------------------------------------------------------
// Shared Objects Sync Primotoves
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

template <class T>
class ReadLock
{
public:
  ReadLock(const Shared<T>& arg) :
    _arg(arg)
  {
    _arg.readlock();
  }
  ~ReadLock()
  {
    _arg.readunlock();
  }

  operator const T() {
    return *_arg.obj();
  }
  operator const T() const {
    return *_arg.obj();
  }
  operator const T&() {
    return *_arg.obj();
  }
  operator const T&() const {
    return *_arg.obj();
  }

private:
  const Shared<T>& _arg;
};

template <class T>
class WriteLock
{
public:
  WriteLock(Shared<T>& arg) :
    _arg(arg)
  {
    _arg.writelock();
  }
  ~WriteLock()
  {
    _arg.writeunlock();
  }

  operator T*() {
    return _arg.obj();
  }

private:
  Shared<T>& _arg;
};



