// ------------------------------------------------------------
// SingletonManager
//
// Manager of Singleton
// A way of managing singleton destruction
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class SingletonManager
{
public:
  // deletion guidelines
  enum How {
    dontcare,
    first,
    last
  };


  //
  // Add singleton to deletion list
  // how specifies guideline for deletion
  void add(Singleton* who, How how = dontcare)
  {
    Synchronize _with(_me);
    
    switch (how) {
    case first:
      // Place as the first in deletion list
      _first.push_back(who);
      break;
      
    case last:
      // last
      _last.push_back(who);
      break;
      
    default:
      _mid.push_back(who);
    }
  };


  //
  // Delete registered singletons
  // When this object is destroyed
  virtual ~SingletonManager()
  {
    Synchronize _with(_me);

    // Clear "first" list
    while (!_first.empty()) {
      delete _first.back();
      _first.pop_back();
    }

    // Clear "mid" list
    while (!_mid.empty()) {
      delete _mid.back();
      _mid.pop_back();
    }

    // Clear "last" list
    while (!_last.empty()) {
      delete _last.back();
      _last.pop_back();
    }
  }
  
private:
  mtvector<Singleton*> _first;
  mtvector<Singleton*> _mid;
  mtvector<Singleton*> _last;

  Mutex _me;
} _singletonmanager;

