// ------------------------------------------------------------
// Stream interfaces
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
// Able to output to stream
//
class Streamable :
  public Sizeable
{
#if DISTMEM
public:
  virtual void pickle(Channel& channel) 
  {
# if DEBUG_EE
    DEBUGOBJ _dummy("STREAMABLE", this, "Pickle");
# endif
    
    _size = size();
    channel.send(&_size, sizeof(_size));
    channel.send(this, _size);
  }


  virtual void depickle(Channel& channel) 
  {
# if DEBUG_EE
    DEBUGOBJ _dummy("STREAMABLE", this, "Depickle");
# endif

    channel.receive(&_size, sizeof(_size));
    channel.receive(this, _size);
  }

protected:
  size_t _size;
#endif
};







