// ------------------------------------------------------------
// Synchronize
// Synchonization helper class
//
//
// Mutex controler
// Called Syncronize so it can be used
// as:
//   Synchronize with(mutex);
//
// notice the use of the dummy variable "with"
//
// Usage of critical sections with these helper
// is exception safe
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class Synchronize
{
public:
  //
  // Lock mutex when constructing
  Synchronize(const Mutex& mutex) :
    _mutex((Mutex*)&mutex)
  {
    _mutex->lock();
  }

  //
  // Unlock it
  ~Synchronize() {
    _mutex->unlock();
  }
  
protected:
  Mutex* _mutex;
};


