// ------------------------------------------------------------
// TCP Server encapsulation
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

//
//
template <class T>
class TCPServer :
  public Server<T>
{
public:
  //
  // Provide handler in compositional idiom
  TCPServer(int port) :
    _port(port)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("TCPSERVER", this, "Construct");
#endif
  }


  // Let the server run
  // Steal the calling thread
  virtual void run()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("TCPSERVER", this, "Run");
#endif
    int newsockfd;

    // Open the socket
    if ((_fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
      FAIL("Server", "Can't open socket", strerror(errno));
    }

    // Configure Socket
    int reuse = 1;
    if (setsockopt(_fd, SOL_SOCKET, SO_REUSEADDR, (char*)&reuse, sizeof(reuse)) < 0) {
      FAIL("Server", "Can't Configure socket", strerror(errno));
    }
    
    // Bind address
    memset((char *) &_serv_addr, 0, sizeof(_serv_addr)); // initialize

    _serv_addr.sin_family = AF_INET;
    _serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);
    _serv_addr.sin_port = htons(_port);

    if (bind(_fd, (sockaddr*) &_serv_addr, sizeof(_serv_addr)) < 0) {
      FAIL("Server", "Can't bind", strerror(errno));
    }

    // Listen
    if (listen(_fd, BACKLOG_MAX) < 0) {
      FAIL("Server", "Fail to listen", strerror(errno));
    }

    // wait for conections and process them
    fd_set ready;
    while (_run()) {
      
      // If signal is caugth continue
      FD_ZERO(&ready);
      FD_SET(_fd, &ready);
      if (select(_fd + 1, &ready, 0, 0, NULL) < 0) {
	if (errno == EINTR) {
          continue;
        }
      }
        
      sockaddr_in cli_addr;
      int clilen = sizeof(cli_addr);

      // Accept the conection
      newsockfd = accept(_fd, (sockaddr*) &cli_addr, &clilen);
      if (newsockfd < 0) {
        FAIL("Server","accept error", strerror(errno));
      }

      // Create a socket object
      // and send to handler
      Socket* socket = new Socket(newsockfd);
      Handler* _handler = newHandler(socket);
      _handler->handle(); // Handler copies itself to another thread!
      delete _handler; _handler = NULL;
    }

    // Close original socket
    close(_fd);
  }

private:
  int _port;
  int _fd;
  sockaddr_in _serv_addr;
};







