// --------------------------------------------------
// ThreadEngine
//
// Handler and Factory for threads.
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

class ThreadEngine :
  public Singleton
{
public:

  //
  // Exceptions
  //
  
  class ExInit :
    public Exception
  {
  public:
    ExInit(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Engine Init";
    }
  };

  class ExDestroy :
    public Exception
  {
  public:
    ExDestroy(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "ThreadEngine Destroy";
    }
  };

  class ExCreate :
    public Exception
  {
  public:
    ExCreate(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Create";
    }
  };

  class ExJoin :
    public Exception
  {
  public:
    ExJoin(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Join";
    }
  };

  class ExDetach :
    public Exception
  {
  public:
    ExDetach(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Detach";
    }
  };

  class ExStack :
    public Exception
  {
  public:
    ExStack(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Stack Size";
    }
  };

  class ExKill :
    public Exception
  {
  public:
    ExKill(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Kill";
    }
  };

  class ExMask :
    public Exception
  {
  public:
    ExMask(char* file, int line) :
      Exception(file, line)
    {}
    void print(ostream& os) const {
      os << "Thread Mask";
    }
  };



  //
  // Methods
  //
  
  Thread_t self();  // throw ()
  
  // Create thread
  void create_local(Thread_t& t,
                    void *(*start_routine) (void *),
                    void* arg); // throw (ExCreate)
  void create_remote(Thread_t& t,
                     void *(*start_routine) (void *),
                     Sizeable* arg); // throw (ExCreate)


  // Join with thread
  void join(const Thread_t& t); // throw (ExJoin)
  // Group Join with thread
  void join(thread_group_t& t); // throw (ExJoin)
  // Join at ThreadEngine Destruction
  void joinWhenDestructing(thread_group_t* group);
  void join_detached();


  // send thread a signal
  void kill(Thread_t& t, int signal); // throw (ExKill)
  void setsigmask(sigset_t *set);

protected:
  //
  // Constructors and Destructor
  ThreadEngine(); // throw (ExInit, ExDetach)
  ~ThreadEngine(); // throw (ExDestroy)

private:
#if DISTMEM
  proc_t _whereIam;
#endif

  // Thread to join with at destruction
  mtvector<thread_group_t*> joinAtDes;
  
  //
  // Thread attributes
#if PTHREADS
  pthread_attr_t thread_attr;
#elif UITHREADS
  // none for UITHREADS threads
#endif

public:
  static ThreadEngine* instance()
  {
    if (_instance == 0) {
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new ThreadEngine;
        _singletonmanager.add(_instance, SingletonManager::last);
      }
    }
    return _instance;
  }
  
private:
  static ThreadEngine* _instance;
  static Mutex _me;
};

// Initialization
ThreadEngine* ThreadEngine::_instance = 0;
Mutex ThreadEngine::_me;


