// ============================================================
//
// ThreadedHandler
//
// Handler in own thread
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ============================================================


class ThreadedHandler :
  public Handler
{
public:
  // Interface
  virtual void handleRequest() = 0;
  virtual ThreadedHandler* clone() = 0;

  // Handle memory management
  virtual void handle()
  {
#if DEBUG_EE
    DEBUGOBJ dummy("THREADEDHANDLER", this, "Handle");
#endif

    void* me = (void*) clone(); // copy this object
    Thread_t t;
    ThreadEngine::instance()->create_local(t, ThreadedHandler::handlerThread, me);
  }

  //
  // Thread entry-point
  static void* handlerThread(void* arg)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("THREADEDHANDLER", arg, "Create Thread");
#endif

    autoptr<ThreadedHandler> _me = (ThreadedHandler*) arg;
    _me->handleRequest();
    return NULL;
  }
};

