// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class ThreadRemoteCreate :
  public CommandWithReply
{
public:
  ThreadRemoteCreate(Thread_t& t) :
    _t(&t),
    r_t(t)
  {}
  
  virtual void operate(CommandHandler& handler)
  {
    _info.depickle(*((PqueueChannel*)handler.queue())->channel());
    ThreadEngine::instance()->create_local(r_t, _info.method, _info.arg);
  }

  virtual void reply(CommandHandler&)
  {
    _t->_t = r_t._t;
  }
  
  virtual size_t size() {
    return sizeof(*this);
  }

  virtual CommandWithReply* clone() {
    return new ThreadRemoteCreate(*this);
  }

protected:  
  CreateThreadInfoRemote _info;
  Thread_t r_t;
  Thread_t* _t;
};
