// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------



class ThreadRemoteJoin :
  public CommandWithReply
{
public:
  ThreadRemoteJoin(const Thread_t& t) :
    _t(t),
    _enqued(FALSE)
  {
    _from = CommunicationEngine::instance()->me();
  }

  virtual void Do(CommandHandler& handler)
  {
    // Perform operations on one end
    if (_return == FALSE) {
      if (_enqued == FALSE) {
        // Create thread to handle request
        _enqued = TRUE;
        JoinManager::instance()->add(this->clone());
      } else {
        operate(handler);
        _return = TRUE;
        *(ProcMap::instance()->channel(_from)) << *this;
      }
    } else {
      // Another
      reply(handler);
      back();
      _return = FALSE;
    }
  }


  virtual void operate(CommandHandler& /* handler */)
  {
    ThreadEngine::instance()->join(_t);
  }

  virtual size_t size() {
    return sizeof(*this);
  }

  virtual CommandWithReply* clone() {
    return new ThreadRemoteJoin(*this);
  }

private:
  Thread_t _t;
  bool _enqued;
  proc_t _from;
};
