// ------------------------------------------------------------
// Wait
//
// Helper for condition variables
// Allows to use condition variables
// in the following construct
//   Wait _while( ...);
// Notice the use of the temp object
// "_while"
// Waiting semantics follow "while". i.e. a
// FALSE condition value will cause the wait
// to end
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class Wait
{
public:
  //
  // Wait on construction
  //
  Wait(Cond& condition, Mutex& mutex) : // throw (Cond::ExWait) 
    _condition(&condition),
    _mutex(&mutex),
    _release(NULL)
  {
    _wait();
  }

  //
  // Wait on construction
  //
  Wait(bool& volatile value, Cond& condition, Mutex& mutex) : // throw (Cond::ExWait) 
    _condition(&condition),
    _mutex(&mutex),
    _release(NULL)
  {
#if DEBUG_EE
    DEBUGOBJ dummy("WAIT", this, "Wait with bool");
#endif
    
    // Wait for the condition
    while (value) {
      _condition->wait(*_mutex);
    }
  }


  //
  // Wait on construction, signal on destruction
  //
  // mjf: what the hell's this for?
  Wait(Cond& condition, Mutex& mutex, Cond& release) : // throw (Cond::ExWait) 
    _condition(&condition),
    _mutex(&mutex),
    _release(&release)
  {
    _wait();
  }

  Wait(Semaphore& sem) : // throw (Cond::ExWait) 
    _condition(&sem.cond()),
    _mutex(&sem.mutex()),
    _release(NULL)
  {
    _mutex->lock();
    _wait();
    _mutex->unlock();
  }

  //
  // If a release condition was given
  // reset it
  //
  ~Wait()
  {
    // signal the release of the state
    if (_release != NULL) {
      _release->value(FALSE);
    }
  }

protected:
  //
  // Well-know condition wait loop
  //
  void _wait() // throw (Cond::ExWait) 
  {
#if DEBUG_EE
    DEBUGOBJ dummy("WAIT", this, "Wait");
#endif
    
    // Wait for the condition
    while (_condition->value()) {
      _condition->wait(*_mutex);
    }
  }

private:
  Mutex* _mutex;
  Cond* _release;
  Cond* _condition;
};
