// --------------------------------------------------
// We elemet interface
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// --------------------------------------------------

//
// Instantiation entry point
void
We::instantiate(DfeNode& parent, AeHandle& handle)
{
#if DEBUG_EE
  DEBUGOBJ dummy("INSTANTIATE", this, "We");
#endif

  // Get Group Info
  idInGroup(parent.getIdInGroup());
  numInGroup(parent.num());

  We* w = clone();
  handle.addThread(WeFactory::instance()->create(w));
}

void
We::releaseQueue()
{}


//
// Closed We
//
class C_we :
  public We,
  public C_DfeNode
{
};

//
// Input
//
template <class T_IN>
class I_we :
  public We,
  public I_DfeNode<T_IN>
{
protected:
  // Set source
  virtual void source(PqueueLocator& loc) {
    pin.locator(loc);
  }

  virtual void initialize() {
    pin.initialize(idInGroup());
  }

  I_PqueueHandle<T_IN> pin;
};

//
// Output
//
template <class T_OUT>
class O_we :
  public We,
  public O_DfeNode<T_OUT>
{
public:
  virtual void releaseQueue() {
    pout.eoq();
  }
protected:
  // Set sink
  virtual void sink(PqueueLocator& loc)  {
    pout.locator(loc);
  }

  virtual void initialize() {
    pout.initialize();
  }
  
  O_PqueueHandle<T_OUT> pout;
};

//
// Input/Output
//
template <class T_IN, class T_OUT>
class IO_we :
  public We,
  public IO_DfeNode<T_IN, T_OUT>
{
public:
  virtual void releaseQueue() {
    pout.eoq();
  }

protected:
  // Set sink
  void sink(PqueueLocator& loc) {
    pout.locator(loc);
  }

  // Set source
  void source(PqueueLocator& loc) {
    pin.locator(loc); 
  }

  virtual void initialize() {
    pin.initialize(idInGroup());
    pout.initialize();
  }

  O_PqueueHandle<T_OUT> pout;
  I_PqueueHandle<T_IN> pin;
};





