// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------



class We :
  public Streamable,
  virtual public DfeNode
{
public:
  We() :
    _idInGroup(0),
    _numInGroup(1)
#if DISTMEM
    , _where(ProcBinding::whereever)
#endif
  {}
  
  virtual void execute() = 0;
  virtual We* clone() = 0;

  virtual void initialize()
  {}


#if DISTMEM
  virtual void where(proc_t w) {
    //    Synchronize _with(_me);
    _where = w;
  }

  virtual proc_t where() {
    //    Synchronize _with(_me);
    return _where;
  }
#endif

  virtual int idInGroup() {
    return _idInGroup;
  }
  virtual void idInGroup(int id) {
    _idInGroup = id;
  }
  virtual int numInGroup() {
    return _numInGroup;
  }
  virtual void numInGroup(int num) {
    _numInGroup = num;
  }

  
  //
  // input only don't needed 
  virtual void releaseQueue();
  //
  // Instantiation entry point
  virtual void instantiate(DfeNode& parent, AeHandle& handle);

protected:
#if 0
  Mutex _me;
#endif


  int _idInGroup;
  int _numInGroup;

#if DISTMEM
  proc_t _where;
#endif
};

