// ------------------------------------------------------------
// 
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


//
// Call execute method of we
// This is the entry point of all threads
//
extern "C" void* we_object_inversion(void * param)
{
#if DEBUG_EE
  DEBUGOBJ dummy("WEBOOT", NULL, "We boot");
#endif

  We* we = (We*) param;

  //
  // allow termination of queues
  // Queue will throw an exception when empty

  try {
    we->initialize();
    we->execute();
  }
  // Stop unroling here
  catch(PqueueBase::ExDead& arg) {
    CATDEBUG("EXCEPTIONSYNC", cerr << arg);
  }
    
  // Clean up
  we->releaseQueue();
  delete we; we = NULL;
  return NULL;
};


