// ------------------------------------------------------------
// We Element Factory
//
// Construct We from prototype
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------

class WeFactory :
  public Singleton
{
public:
  Thread_t create(We* we)
  {
    Thread_t t;
    
#if DISTMEM
    t._where = we->where();
#endif
    
    ThreadEngine::instance()->create_remote(t, &we_object_inversion, we);
    return t;
  }

protected:
  WeFactory() 
  {
#if DISTMEM
    // Find out where I am.
    _whereami = CommunicationEngine::instance()->me();
#endif
  }

  virtual ~WeFactory()
  {}

private:
#if DISTMEM
  proc_t _whereami;
#endif
  
  // Singleton stuff
public:
  // singleton instance method
  static WeFactory* instance()
  {
    if (_instance == 0) {
      // Make sure no race condition are around
      Synchronize _with(_me);
      if (_instance == 0) {
        _instance = new WeFactory;
        _singletonmanager.add(_instance, SingletonManager::dontcare);
      }
    }
    return _instance;
  }

private:
  static WeFactory* _instance;
  static Mutex _me;
};

// Initialization
WeFactory* WeFactory::_instance = 0;
Mutex WeFactory::_me;

