// ------------------------------------------------------------
// Worker Element Definitions for Test Programs
//
// Mauricio De Simone
// mdesimon@interlog.com
//
// Copyright (C) 1998  Mauricio De Simone
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation version 2.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// ------------------------------------------------------------


static int num_elements = 10;
#define DATA_SIZE 10



class Int : 
  public Streamable
{
public:
  Int()
  {
    ///    MSG("Data",this,"Default Constructor");
  }
  
  Int(int data) 
  {
    _data[0] = data;
    //    MSG("Data",this,"Argument Constructor");
  }

  Int(const Int& arg)
  {
    //    MSG("Data",this,"Copy Constructor from", &arg);
    *_data = *(arg._data);
  }

  void operator=(const Int& arg)
  {
    //    MSG("Data",this,"Operator = from", &arg);
    *_data = *(arg._data);
  }    

  void operator=(const int i)
  {
    //    MSG("Data",this,"Operator = (int) from", i);
    _data[0] = i;
  }
  
  ~Int()
  {
    //    MSG("Data",this,"Destructor");
  }

#if 0 
  void pickle(Channel& channel) {

    MSG("Pickling DATA");
    channel.send(_data, sizeof(_data));
  }

  void depickle(Channel& channel) {
    MSG("Depickling DATA");
    channel.receive(_data, sizeof(_data));
  }
#endif

  operator int() {
    return _data[0];
  }
  
  virtual size_t size() {
    //    MSG("sizeof(*this)", sizeof(*this));
    return sizeof(*this);
  }

  int _data[DATA_SIZE];
};




class CWe : public C_we
{
public:
  void execute() {
    MSG("CWe",this);
  };


  We* clone() {
    return new CWe(*this);
  }
  virtual size_t size() {
    return sizeof(*this);
  }
};

class IWe :
  public I_we<Int>
{
public:
  void execute() {
    MSG("+++ Starting IWe", this, idInGroup());
    Int a;
    while (pin >> a) {
      MSG("IWe", this, int(a));
    }
    MSG("+++ Ending IWe", this, idInGroup());
  }

  We* clone() {
    return new IWe(*this);
  }
  virtual size_t size() {
    return sizeof(*this);
  }
};

class OWe :
  public O_we<Int>
{
public:
  OWe(int num=10) : _num(num) {}

private:
  void execute() {
    MSG("+++ Starting OWe", this);
    Int I;
    for (int i = 0; i < _num; i++) {
      I = i;
      pout << I;
      MSG("OWe", this, i);
    }
    MSG("+++ Ending OWe", this);
  }
  
  We* clone() {
    return new OWe(*this);
  }
  virtual size_t size() {
    return sizeof(*this);
  }

  int _num;
};

class IOWe :
  public IO_we<Int, Int>
{
  void execute() {
    MSG("+++ Starting IOWe", this, idInGroup());
    Int a;
    while (pin >> a) {
      MSG("IOWe", this, int(a));
      pout << a;
    }
  }
  
  We* clone() {
    return new IOWe(*this);
  }
  virtual size_t size() {
    return sizeof(*this);
  }
};




