// OriginChoice.java

import java.awt.*;
import java.applet.Applet;

public class OriginChoice extends Applet {
    public void init() {
        resize(200, 30);
        setBackground(Color.white);

        originChoice = new Choice();
        originChoice.addItem("United States");
        originChoice.addItem("United Kingdom");
        originChoice.addItem("New Zealand");

        add(originChoice);

        origin = new Origin();
    }

    public boolean handleEvent(Event event) {
        if (event.id == Event.ACTION_EVENT && event.target == originChoice) {
            if ((String) event.arg == "United States")
                origin.set(Origin.US);
            else if ((String) event.arg == "United Kingdom")
                origin.set(Origin.UK);
            else if ((String) event.arg == "New Zealand")
                origin.set(Origin.NZ);

            return true;
        }

        return super.handleEvent(event);        // not a Choice event
    }

    public void start() {
        // ensure that, on startup or return to page, choice is set to current
        if (originChoice != null && origin != null)
            try {
                originChoice.select(origin.get());
            }
            catch (IllegalArgumentException e) {
            }
    }

    private Choice originChoice;
    private Origin origin;
}