// PopupRates.java

import java.util.Hashtable;
import java.util.StringTokenizer;

public class PopupRates extends PopupText {
    public void init() {
        super.init();
        ratesTable = new Hashtable(8);
        initRatesTable(getParameter("data"), getParameter("numrates"));
        origin = new Origin();
    }

    private void initRatesTable(String data, String numRatesStr) {
        int numRates;

        try {
            numRates = Integer.parseInt(numRatesStr, 10);
        }
        catch (NumberFormatException e) {
            numRates = 0;
            return;
        }

        String originStr;
        StringTokenizer strTok = new StringTokenizer(data, ",");

        for (int i = 0; i < numOrigins; ++i) {
            String[] rates = new String[numRates];
            originStr = strTok.nextToken();
            for (int j = 0; j < numRates; ++j)
                rates[j] = strTok.nextToken();
            ratesTable.put(originStr, rates);
        }
    }

    protected String[] getText() {
        char currencySymbol;
        String originStr;

        switch (origin.get()) {
            case Origin.UK:
                currencySymbol = '';
                originStr = "UK";
                break;
            case Origin.NZ:
                currencySymbol = '$';
                originStr = "NZ";
                break;
            case Origin.US:
            default:
                currencySymbol = '$';
                originStr = "US";
        }

        StringBuffer line = new StringBuffer("Daily tariff (");
        String[] lines = new String[5];

        line.append(currencySymbol + originStr + ")");
        lines[0] = line.toString();
        if (ratesTable != null) {
            lines[1] = "";
            lines[2] = "Economy: " + currencySymbol + ((String[]) ratesTable.get(originStr))[0];
            lines[3] = "Luxury: " + currencySymbol + ((String[]) ratesTable.get(originStr))[1];
            lines[4] = "Presidential: " + currencySymbol + ((String[]) ratesTable.get(originStr))[2];
        }

        return lines;
    }

    private Hashtable ratesTable = null;

    private final int numOrigins = 3;
    private String data = "US,-,-,-,UK,-,-,-,NZ,-,-,-";

    private Origin origin;
}