// PopupTravel.java

import java.util.Hashtable;
import java.util.StringTokenizer;

public class PopupTravel extends PopupText {
    public void init() {
        super.init();
        timesTable = new Hashtable(8);
        initTimesTable(getParameter("data"));
        origin = new Origin();
    }

    private void initTimesTable(String data) {
        String originStr;
        StringTokenizer strTok = new StringTokenizer(data, ",");

        for (int i = 0; i < numOrigins; ++i) {
            originStr = strTok.nextToken();
            timesTable.put(originStr, strTok.nextToken());
        }
    }

    protected String[] getText() {
        String originStr;

        switch (origin.get()) {
            case Origin.UK:
                originStr = "UK";
                break;
            case Origin.NZ:
                originStr = "NZ";
                break;
            case Origin.US:
            default:
                originStr = "US";
        }

        StringBuffer line = new StringBuffer("From nearest ");
        String[] lines = new String[3];

        line.append(originStr + " airport:");
        lines[0] = line.toString();
        if (timesTable != null) {
            lines[1] = "";
            lines[2] = "Approx. " + (String) timesTable.get(originStr) + " hours";
        }

        return lines;
    }

    private Hashtable timesTable = null;

    private final int numOrigins = 3;
    private String data = "US,-,UK,-,NZ,-";

    private Origin origin;
}