// TextBox.java

import java.awt.*;

class TextBox extends Window {
    TextBox(Frame parent, int width, int height, Color background) {
        super(parent);
        textCanvas = new TextCanvas(width, height, background);
        add("Center", textCanvas); // default layout for Window is BorderLayout
        pack();
    }

    public boolean mouseDown(Event e, int x, int y) {
        hide();
        return true;
    }

    public void paint(Graphics g) {
        g.setColor(Color.black);
        g.drawRect(0, 0, size().width - 1, size().height - 1);
    }

    public void setText(String[] lines) {
        textCanvas.lines = lines;
        textCanvas.repaint();
    }

    public void show(Point midPoint) {
        move(midPoint.x - size().width / 2, midPoint.y);
        show();
    }

    public Insets insets() {
        Insets i = (Insets) super.insets().clone();
        ++i.top; ++i.left; ++i.bottom; ++i.right;
        return i;
    }
  
    private TextCanvas textCanvas;
}

class TextCanvas extends Canvas
{
    TextCanvas(int width, int height, Color background) {
        this.width = width;
        this.height = height;
        setBackground(this.background = background);
    }

    public void paint(Graphics g) {
        g.setColor(background.equals(Color.black) ? Color.white : Color.black);

        for (int i = 0, y = lineSpacing; i < lines.length; ++i, y += lineSpacing)
            g.drawString(lines[i], margin, y);
    }

    public Dimension preferredSize() {
        return new Dimension(width, height );
    }

    String[] lines;

    private int width;
    private int height;
    private Color background;
    private final int lineSpacing = 15;
    private final int margin = 10;
}