// OriginChoice.java

import java.awt.*;
import java.applet.Applet;

public class OriginChoice extends Applet {
    public void init() {
        resize(200, 30);
        setBackground(Color.white);

        originChoice = new Choice();
        originChoice.addItem("United States");
        originChoice.addItem("United Kingdom");
        originChoice.addItem("New Zealand");

        add(originChoice);

        origin = US;
    }

    public boolean handleEvent(Event event) {
        if (event.id == Event.ACTION_EVENT && event.target == originChoice) {
            if ((String) event.arg == "United States")
                origin = US;
            else if ((String) event.arg == "United Kingdom")
                origin = UK;
            else if ((String) event.arg == "New Zealand")
                origin = NZ;

            return true;
        }

        return super.handleEvent(event);    // not a Choice event
    }

    public int getOrigin() {
        return origin;
    }

    public final static int US = 0;
    public final static int UK = 1;
    public final static int NZ = 2;

    private Choice originChoice;
    private int origin;
}