// Scribble.java

import java.applet.*;
import java.awt.*;
import java.util.Vector;

public class Scribble extends Applet {
    public Scribble() {}

    public void init() {
        setBackground(Color.white);
    }

    public void paint(Graphics g) {
        for (int i = 0; i < lines.size(); ++i)
            drawLine(g, (Line) lines.elementAt(i));
    }

    public boolean mouseDown(Event evt, int x, int y) {
        start = new Point(x, y);
        return true;
    }

    public boolean mouseDrag(Event evt, int x, int y) {
        Line line = new Line(start.x, start.y, x, y, Palette.getPaletteColor());
        lines.addElement(line);
        drawLine(getGraphics(), line);
        start = new Point(x, y);
        return true;
    }

    private void drawLine(Graphics g, Line line) {
        g.setColor(line.color);
        for (int dx = -1; dx <= 1; ++dx)
            for (int dy = -1; dy <= 1; ++dy)
                g.drawLine(line.x1 + dx, line.y1 + dy, line.x2 + dx, line.y2 + dy);
    }

    private Vector lines = new Vector();

    private Point start;
}

class Line extends Rectangle {
    Line(int x1, int y1, int x2, int y2, Color color) {
        this.x1 = x1;
        this.y1 = y1;
        this.x2 = x2;
        this.y2 = y2;
        this.color = color;
    }
    int x1, y1, x2, y2;
    Color color;
}