/*------------------------------------------------*/
/*  This defines the message types and parameter  */
/*  structures                                    */
/*------------------------------------------------*/              






          /* ISDN Common API message types                            */

#define _ALERT_R                        0x8001
#define _CONNECT_R                      0x8002
#define _CONNECT_I                      0x8202
#define _CONNECT_ACTIVE_I               0x8203
#define _DISCONNECT_R                   0x8004
#define _DISCONNECT_I                   0x8204
#define _LISTEN_R                       0x8005
#define _INFO_R                         0x8008
#define _INFO_I                         0x8208

#define _SELECT_B_REQ                   0x8041

#define _FACILITY_R                     0x8080
#define _FACILITY_I                     0x8280
#define _CONNECT_B3_R                   0x8082
#define _CONNECT_B3_I                   0x8282
#define _CONNECT_B3_ACTIVE_I            0x8283
#define _DISCONNECT_B3_R                0x8084
#define _DISCONNECT_B3_I                0x8284
#define _DATA_B3_R                      0x8086
#define _DATA_B3_I                      0x8286
#define _RESET_B3_R                     0x8087
#define _RESET_B3_I                     0x8287
#define _CONNECT_B3_T90_ACTIVE_I        0x8288

#define _MANUFACTURER_R                 0x80ff
#define _MANUFACTURER_I                 0x82ff

        /* OR this to convert a REQUEST to a CONFIRM                */

#define CONFIRM                 0x0100

        /* OR this to convert a INDICATION to a RESPONSE            */

#define RESPONSE                0x0100

/*------------------------------------------------------------------*/
/* diehl isdn private MANUFACTURER codes                            */
/*------------------------------------------------------------------*/

#define _DI_MANU_ID             0x44444944

#define _DI_ASSIGN_PLCI         0x01

/*------------------------------------------------------------------*/
/* parameter structures                                             */
/*------------------------------------------------------------------*/

        /* ALERT-REQUEST                                            */

typedef struct {
  BYTE structs[1];      /* Additional Info */
} _ALT_REQP;

        /* ALERT-CONFIRM                                            */

typedef struct {
  WORD Info;
} _ALT_CONP;

        /* CONNECT-REQUEST                                          */

typedef struct {
  WORD CIP_Value;
  BYTE structs[1];      /* Called party number,
                           Called party subaddress,
                           Calling party number,
                           Calling party subaddress,
                           B_protocol,
                           BC,
                           LLC,
                           HLC,
                           Additional Info */
} _CON_REQP;

        /* CONNECT-CONFIRM                                          */

typedef struct {
  WORD Info;
} _CON_CONP;

        /* CONNECT-INDICATION                                       */

typedef struct {
  WORD CIP_Value;
  BYTE structs[1];      /* Called party number,
                           Called party subaddress,
                           Calling party number,
                           Calling party subaddress,
                           BC,
                           LLC,
                           HLC,
                           Additional Info */
} _CON_INDP;

        /* CONNECT-RESPONSE                                         */

typedef struct {
  WORD Accept;
  BYTE structs[1];      /* B_protocol,
                           Connected party number,
                           Connected party subaddress,
                           LLC */
} _CON_RESP;

        /* CONNECT-ACTIVE-INDICATION                                */

typedef struct {
  BYTE structs[1];      /* Connected party number,
                           Connected party subaddress,
                           LLC */


                           } _CON_A_INDP;

        /* CONNECT-ACTIVE-RESPONSE                                  */

typedef struct {
  BYTE structs[1];      /* empty */
} _CON_A_RESP;

        /* DISCONNECT-REQUEST                                       */

typedef struct {
  BYTE structs[1];      /* Additional Info */
} _DIS_REQP;

        /* DISCONNECT-CONFIRM                                       */

typedef struct {
  WORD Info;
} _DIS_CONP;

        /* DISCONNECT-INDICATION                                    */

typedef struct {
  WORD Info;
} _DIS_INDP;

        /* DISCONNECT-RESPONSE                                      */

typedef struct {
  BYTE structs[1];      /* empty */
} _DIS_RESP;

        /* LISTEN-REQUEST                                           */

typedef struct {
  DWORD Info_Mask;
  DWORD CIP_Mask;
  BYTE structs[1];      /* Calling party number,
                           Calling party subaddress */
} _LIS_REQP;

        /* LISTEN-CONFIRM                                           */

typedef struct {
  WORD Info;
} _LIS_CONP;

        /* INFO-REQUEST                                             */

typedef struct {
  BYTE structs[1];      /* Called party number,
                           Additional Info */
} _INF_REQP;

        /* INFO-CONFIRM                                             */

typedef struct {
  WORD Info;
} _INF_CONP;

        /* INFO-INDICATION                                          */

typedef struct {
  WORD Number;
  BYTE structs[1];      /* Info element */
} _INF_INDP;

        /* INFO-RESPONSE                                            */

typedef struct {
  BYTE structs[1];      /* empty */
} _INF_RESP;

        /* SELECT-B-REQUEST                                         */

typedef struct {
  BYTE structs[1];      /* B-protocol */
} _SEL_B_REQP;

        /* SELECT-B-CONFIRM                                         */

typedef struct {
  WORD Info;
} _SEL_B_CONP;

        /* FACILITY-REQUEST */

typedef struct {
  WORD Selector;
  BYTE structs[1];      /* Facility parameters */
} _FAC_REQP;

        /* FACILITY-CONFIRM */

typedef struct {
  WORD Info;
  WORD Selector;
  BYTE structs[1];      /* Facility parameters */
} _FAC_CONP;

        /* FACILITY-INDICATION */

typedef struct {
  WORD Selector;
  BYTE structs[1];      /* Facility parameters */
} _FAC_INDP;

        /* FACILITY-RESPONSE */

typedef struct {
  WORD Selector;
  BYTE structs[1];      /* Facility parameters */
} _FAC_RESP;

        /* CONNECT-B3-REQUEST                                       */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _CON_B3_REQP;

        /* CONNECT-B3-CONFIRM                                       */

typedef struct {
  WORD Info;
} _CON_B3_CONP;

        /* CONNECT-B3-INDICATION                                    */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _CON_B3_INDP;

        /* CONNECT-B3-RESPONSE                                      */

typedef struct {
  WORD Accept;
  BYTE structs[1];      /* NCPI */
} _CON_B3_RESP;

        /* CONNECT-B3-ACTIVE-INDICATION                             */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _CON_B3_A_INDP;

        /* CONNECT-B3-ACTIVE-RESPONSE                               */

typedef struct {
  BYTE structs[1];      /* empty */
} _CON_B3_A_RESP;


        /* DISCONNECT-B3-REQUEST                                    */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _DIS_B3_REQP;

        /* DISCONNECT-B3-CONFIRM                                    */

typedef struct {
  WORD Info;
} _DIS_B3_CONP;

        /* DISCONNECT-B3-INDICATION                                 */

typedef struct {
  WORD Info;
  BYTE structs[1];      /* NCPI */
} _DIS_B3_INDP;

        /* DISCONNECT-B3-RESPONSE                                   */

typedef struct {
  BYTE structs[1];      /* empty */
} _DIS_B3_RESP;

        /* DATA-B3-REQUEST                                          */

typedef struct {
  DWORD         Data;
  WORD          Data_Length;
  WORD          Number;
  WORD          Flags;
} _DAT_B3_REQP;

        /* DATA-B3-CONFIRM                                          */

typedef struct {
  WORD          Number;
  WORD          Info;
} _DAT_B3_CONP;

        /* DATA-B3-INDICATION                                       */

typedef struct {
  DWORD         Data;
  WORD          Data_Length;
  WORD          Number;
  WORD          Flags;
} _DAT_B3_INDP;

        /* DATA-B3-RESPONSE                                         */

typedef struct {
  WORD          Number;
} _DAT_B3_RESP;

        /* RESET-B3-REQUEST                                         */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _RES_B3_REQP;

        /* RESET-B3-CONFIRM                                         */

typedef struct {
  WORD Info;
} _RES_B3_CONP;

        /* RESET-B3-INDICATION                                      */

typedef struct {
  BYTE structs[1];      /* NCPI */
} _RES_B3_INDP;

        /* RESET-B3-RESPONSE                                        */

typedef struct {
  BYTE structs[1];      /* empty */
} _RES_B3_RESP;

        /* CONNECT-B3-T90-ACTIVE-INDICATION                         */
typedef struct {
  BYTE structs[1];      /* NCPI */
} _CON_B3_T90_A_INDP;

        /* CONNECT-B3-T90-ACTIVE-RESPONSE                           */
typedef struct {
  WORD Reject;
  BYTE structs[1];      /* NCPI */
} _CON_B3_T90_A_RESP;

/*------------------------------------------------------------------*/
/* message structure                                                */
/*------------------------------------------------------------------*/

typedef struct _API_MSG CAPI_MSG;
typedef struct _MSG_HEADER CAPI_MSG_HEADER;

struct _API_MSG {
  struct _MSG_HEADER {
    WORD        length;
    WORD        appl_id;
    WORD        command;
    WORD        number;
    BYTE        controller;
    BYTE        plci;
    WORD        ncci;
  } header;
  union {
    _ALT_REQP           alert_req;
    _ALT_CONP           alert_con;
    _CON_REQP           connect_req;
    _CON_CONP           connect_con;
    _CON_INDP           connect_ind;
    _CON_RESP           connect_res;
    _CON_A_INDP         connect_a_ind;
    _CON_A_RESP         connect_a_res;
    _DIS_REQP           disconnect_req;
    _DIS_CONP           disconnect_con;
    _DIS_INDP           disconnect_ind;
    _DIS_RESP           disconnect_res;
    _LIS_REQP           listen_req;
    _LIS_CONP           listen_con;
    _INF_REQP           info_req;
    _INF_CONP           info_con;
    _INF_INDP           info_ind;
    _INF_RESP           info_res;
    _SEL_B_REQP         select_b_req;
    _SEL_B_CONP         select_b_con;
    _FAC_REQP           facility_req;
    _FAC_CONP           facility_con;
    _FAC_INDP           facility_ind;
    _FAC_RESP           facility_res;
    _CON_B3_REQP        connect_b3_req;
    _CON_B3_CONP        connect_b3_con;
    _CON_B3_INDP        connect_b3_ind;
    _CON_B3_RESP        connect_b3_res;
    _CON_B3_A_INDP      connect_b3_a_ind;
    _CON_B3_A_RESP      connect_b3_a_res;
    _DIS_B3_REQP        disconnect_b3_req;
    _DIS_B3_CONP        disconnect_b3_con;
    _DIS_B3_INDP        disconnect_b3_ind;
    _DIS_B3_RESP        disconnect_b3_res;
    _DAT_B3_REQP        data_b3_req;
    _DAT_B3_CONP        data_b3_con;
    _DAT_B3_INDP        data_b3_ind;
    _DAT_B3_RESP        data_b3_res;
    _RES_B3_REQP        reset_b3_req;
    _RES_B3_CONP        reset_b3_con;
    _RES_B3_INDP        reset_b3_ind;
    _RES_B3_RESP        reset_b3_res;
    _CON_B3_T90_A_INDP  connect_b3_t90_a_ind;
    _CON_B3_T90_A_RESP  connect_b3_t90_a_res;
    BYTE                b[200];
  } info;
} ;

