/*---------------------------------------------------------------------------*/
/*
  File: capi2032.h

  Interface of CAPI 2.0 DLL for Windows NT

  Copyright (c) G.Diehl-ISDN GmbH 1995
*/
/*---------------------------------------------------------------------------*/

#ifndef CAPI2032_H_
#define CAPI2032_H_

#define STRICT
#include <windows.h>


#ifdef __cplusplus
extern "C" {
#endif
/*---------------------------------------------------------------------------*/

DWORD APIENTRY CAPI_REGISTER (DWORD MessageBufferSize,
                              DWORD MaxLogicalConnection,
                              DWORD MaxBDataBlocks,
                              DWORD MaxBDataLen,
                              DWORD *pApplID);

DWORD APIENTRY CAPI_RELEASE (DWORD ApplID);

DWORD APIENTRY CAPI_PUT_MESSAGE (DWORD ApplID,
                                 PVOID pCAPIMessage);

DWORD APIENTRY CAPI_GET_MESSAGE (DWORD ApplID,
                                 PVOID *ppCAPIMessage);

DWORD APIENTRY CAPI_WAIT_FOR_SIGNAL (DWORD ApplID);

VOID  APIENTRY CAPI_GET_MANUFACTURER (CHAR *szBuffer);

DWORD APIENTRY CAPI_GET_VERSION (DWORD *pCAPIMajor,
                                 DWORD *pCAPIMinor,
                                 DWORD *pManufacturerMajor,
                                 DWORD *pManufacturerMinor);

DWORD APIENTRY CAPI_GET_SERIAL_NUMBER (CHAR *szBuffer);

DWORD APIENTRY CAPI_GET_PROFILE (PVOID pBuffer,
                                 DWORD CtrlNr);

DWORD APIENTRY CAPI_INSTALLED (VOID);


/*---------------------------------------------------------------------------*/
#ifdef __cplusplus
}
#endif

#endif

