
/*
 *	init.c
 *
 *	QNX 4
 *
 *	(C) Copyright 1997 by Robert Krten, all rights reserved.
 *
 *	This module contains the initialization code
 *
 *	1997 01 11	R. Krten		created, partly stole from Dev.ser source
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <conio.h>
#include <i86.h>

#include "x10.h"

extern	char	*progname;					// main.c
extern	char	*version;					// version.c

extern	int		optv;						// main.c, verbose operation flag

void
initPort (port)
int		port;
{
	unsigned int	value;

	/*
	 *	Set Baud rate to 9k baud
	*/

	value = 115200 / 9000;		// 9k baud == 1 ms pulse at 9 bits...

	_disable ();
	set_port (port + R_LC, LCR_DLAB_MASK, LCR_DLAB_ON);
	set_port (port + R_DL, 0xff, value & 0xff);
	set_port (port + R_DH, 0xff, value >> 8);
	set_port (port + R_LC, LCR_DLAB_MASK, LCR_DLAB_OFF);

	/*
	 * Set parity, stop bits and data bits
	*/

	set_port (port + R_LC, 0xff, LCR_8_DATA_BITS | LCR_1_STOP_BIT | LCR_PARITY_DISABLED);

	/*
	 * Save initial modem status, and also clear all interrupts
	*/

	outp (port + R_IE, 0x00);		// Disable all interrupts
	inp (port + R_LS);				// Clear Line Status Interrupt
	inp (port + R_RX);				// Clear RX Interrupt
	inp (port + R_II);				// Clear TX Interrupt (by reading IIR)
	inp (port + R_MS);				// Clear Modem Interrupt

	/*
	 * turn on DTR, turn off RTS
	*/

	set_port (port + R_MC, MCR_DTR_MASK | MCR_RTS_MASK, MCR_DTR_LOW | MCR_RTS_HIGH);

	/*
	 * Enable just the modem status as an interrupt source
	*/

	outp (port + R_IE, IER_MS);

	_enable();
}
	
void
set_port (port, mask, data)
unsigned int	port, mask, data;
{
	unsigned char	c;

	c = inp (port);
	outp (port, (c & ~mask) | (data & mask));
}

